###################################################################################################
####################################       read in data      ######################################
###################################################################################################
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

################### plot genes
# OLD
# selected_cluster <- c(1,9,20,17,2,8,5)
# selected_cluster_name <- c("DOWN-EARLY","DOWN-LATE","UP-EARLY","UP-LATE","TRANSIENT-UP-EARLY","TRANSIENT-UP-MIDDLE","TRANSIENT-UP-LATE")

# NEW
# selected_cluster <- c(10,11,4,5,8,6,2)

K4me3C4 <- as.vector(read.table("../data/Fig6A/naiveK4me3PositiveGeneCluster4.txt")[,1])
methyC4 <- as.vector(read.table("../data/Fig6A/naiveMethylatedNegativeGeneCluster4.txt")[,1])
K4me3C5 <- as.vector(read.table("../data/Fig6A/naiveK4me3PositiveGeneCluster5.txt")[,1])
methyC5 <- as.vector(read.table("../data/Fig6A/naiveMethylatedNegativeGeneCluster5.txt")[,1])
K4me3C11 <- as.vector(read.table("../data/Fig6A/naiveK4me3PositiveGeneCluster11.txt")[,1])
methyC11 <- as.vector(read.table("../data/Fig6A/naiveMethylatedNegativeGeneCluster11.txt")[,1])
K4me3C10 <- as.vector(read.table("../data/Fig6A/naiveK4me3PositiveGeneCluster10.txt")[,1])
methyC10 <- as.vector(read.table("../data/Fig6A/naiveMethylatedNegativeGeneCluster10.txt")[,1])

C4 <- union(K4me3C4,methyC4)
K4me3UniqC4 <- setdiff(K4me3C4,methyC4)
methyUniqC4 <- setdiff(methyC4,K4me3C4)
commonC4 <- intersect(K4me3C4,methyC4)

C5 <- union(K4me3C5,methyC5)
K4me3UniqC5 <- setdiff(K4me3C5,methyC5)
methyUniqC5 <- setdiff(methyC5,K4me3C5)
commonC5 <- intersect(K4me3C5,methyC5)

C11 <- union(K4me3C11,methyC11)
K4me3UniqC11 <- setdiff(K4me3C11,methyC11)
methyUniqC11 <- setdiff(methyC11,K4me3C11)
commonC11 <- intersect(K4me3C11,methyC11)

C10 <- union(K4me3C10,methyC10)
K4me3UniqC10 <- setdiff(K4me3C10,methyC10)
methyUniqC10 <- setdiff(methyC10,K4me3C10)
commonC10 <- intersect(K4me3C10,methyC10)

################### plot data
## 2nd naive gene expression
logfpkm2nd <- read.table("../data/2nd.reprogramming.lg2.all.fpkm.txt",header=T,row.names=1)
n_path <- c("hiF_r1","hiF_r2","he0_r1","he0_r2","he2_r1","he2_r2","he6_r1","he6_r2","n8_r1","n8_r2","n8_r3","n12_r1","n12_r2","n14_r1","n14_r2","n14_r3","n20_r1","n20_r2","n20_r3","n24p_r1","n24p_r2","n24m_r1","n24m_r2","niPS_r1","niPS_r2")
nData_tmp <- logfpkm2nd[,n_path]
nfpkm2nd <- 2**nData_tmp - 1
n_time_point <- c("hiF","he0","he2","he6","n8","n12","n14","n20","n24pdox","n24mdox","niPS")
n_label <- c("hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T")
nData2ndfpkm <- cbind(apply(nfpkm2nd[,1:2],1,mean),apply(nfpkm2nd[,3:4],1,mean),apply(nfpkm2nd[,5:6],1,mean),apply(nfpkm2nd[,7:8],1,mean),apply(nfpkm2nd[,9:11],1,mean),apply(nfpkm2nd[,12:13],1,mean),apply(nfpkm2nd[,14:16],1,mean),apply(nfpkm2nd[,17:19],1,mean),apply(nfpkm2nd[,20:21],1,mean),apply(nfpkm2nd[,22:23],1,mean),apply(nfpkm2nd[,24:25],1,mean))
colnames(nData2ndfpkm) <- n_time_point
rownames(nData2ndfpkm) <- rownames(nfpkm2nd)
nData <- log2(nData2ndfpkm[,]+1)
n_deg <- read.table("../Fig2/Gfold/cutoff.0.58/naive.2nd.deg")[,1]
n_deg <- intersect(n_deg,rownames(nData))
nData <- nData[n_deg,]
## 2nd naive DNA methylation ratio on promoter
methyratio_promoter <- read.table("../data/2nd_average_methratio_on_promoter.txt",header=T,row.names=1)
hiFT <- methyratio_promoter[,"hiFT"]
he6 <- methyratio_promoter[,"he6"]
n12 <- apply(methyratio_promoter[,c("n12","n12_r2")],1,mean,na.rm=TRUE)
n20 <- methyratio_promoter[,"n20"]
n24 <- methyratio_promoter[,"n24"]
niPS <- methyratio_promoter[,"niPS"]
methyratio_promoter <- cbind(hiFT,he6,n12,n20,n24,niPS)
methy_n_path <- c("hiFT","he6","n12","n20","n24","niPS")
methy_n_label <- c("hiF-T","6d","12d","20d","24d+dox","niPSC-T")
## 2nd naive HM on promoter
# hm_promoter <- read.table("../data/HM_gene_promoter_uniq_all.txt",header=T,row.names=1)
hm_promoter <- read.table("../data/HM_gene_promoter_uniq_all_0327.txt",header=T,row.names=1)

hm_n_path <- c("hiF","he6","n24","niPS")
hm_p_path <- c("hiF","he6","p24","piPS")
n_K4me2_path <- c("hiF_K4me2","he6_K4me2","n24_K4me2","niPS_K4me2")
p_K4me2_path <- c("hiF_K4me2","he6_K4me2","p24_K4me2","piPS_K4me2")
n_K4me3_path <- c("hiF_K4me3","he6_K4me3","n24_K4me3","niPS_K4me3")
p_K4me3_path <- c("hiF_K4me3","he6_K4me3","p24_K4me3","piPS_K4me3")

n_K27me3_path <- c("hiF_K27me3","he6_K27me3","n24_K27me3","niPS_K27me3")
p_K27me3_path <- c("hiF_K27me3","he6_K27me3","p24_K27me3","piPS_K27me3")

hm_n_label <- c("hiF-T","6d","24d+dox","niPSC-T")
################### sequence feature
cg_ratio <- read.table("../data/hg19.promoter.CG.density.uniq.txt",row.names=1)

###################################################################################################
####################################         heatmap         ######################################
###################################################################################################

all_exp <- c(as.matrix(nData[c(C4,C11,C5,C10),]))
exp_max <- quantile(all_exp,0.99)
exp_min <- quantile(all_exp,0.01)
methy_max <- 1
methy_min <- 0
all_K4me2 <- c(as.matrix(hm_promoter[c(C4,C11,C5,C10),n_K4me2_path]))
K4me2_max <- quantile(na.omit(all_K4me2),0.99)
K4me2_min <- quantile(na.omit(all_K4me2),0.01)
all_K4me3 <- c(as.matrix(hm_promoter[c(C4,C11,C5,C10),n_K4me3_path]))
K4me3_max <- quantile(na.omit(all_K4me3),0.99)
K4me3_min <- quantile(na.omit(all_K4me3),0.01)
all_K27me3 <- c(as.matrix(hm_promoter[c(C4,C11,C5,C10),n_K27me3_path]))
K27me3_max <- quantile(na.omit(all_K27me3),0.99)
K27me3_min <- quantile(na.omit(all_K27me3),0.01)
CG_ratio_max <- quantile(na.omit(cg_ratio[,1]),0.99)
CG_ratio_min <- quantile(na.omit(cg_ratio[,1]),0.01)

pdf("UP-EARLY.pdf",width=length(C4)/20+1,height=6)
par(oma=c(0.5,0.5,0.5,0.5),mar=c(1,4,1,2))
layout(matrix(c(rep(1,6),rep(2,3),rep(3,2),rep(4,2),rep(5,2),rep(6,1),rep(7,1)),nrow=17,ncol=1,byrow=T))
# gene expression
ColorRamp <- colorRampPalette(c("white","lightblue","#FF3300","red"), bias=1)(1000)
plotMatrix <- nData[c(K4me3UniqC4,commonC4,methyUniqC4),rev(n_time_point)]
plotMatrix[plotMatrix<exp_min] <- exp_min
plotMatrix[plotMatrix>exp_max] <- exp_max
ColorLevels <- seq(to=exp_max,from=exp_min, length=1000)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), plotMatrix, axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(n_label),las=2)
abline(v=length(K4me3UniqC4)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC4)+length(commonC4)+0.5,lty=1,lwd=3)
# DNA methylation
ColorRamp <- colorRampPalette(c("white","black"), bias=1)(100)
plotMatrix <- methyratio_promoter[c(K4me3UniqC4,commonC4,methyUniqC4),rev(methy_n_path)]
# plotMatrix[is.na(plotMatrix)] <- 0
ColorLevels <- seq(to=methy_max,from=methy_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(methy_n_label),las=2)
abline(v=length(K4me3UniqC4)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC4)+length(commonC4)+0.5,lty=1,lwd=3)
# K4me2
ColorRamp <- colorRampPalette(c("white",cccol[1]), bias=1)(100)
plotMatrix <- hm_promoter[c(K4me3UniqC4,commonC4,methyUniqC4),rev(n_K4me2_path)]
ColorLevels <- seq(to=K4me2_max,from=K4me2_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(hm_n_label),las=2)
abline(v=length(K4me3UniqC4)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC4)+length(commonC4)+0.5,lty=1,lwd=3)
# K4me3
ColorRamp <- colorRampPalette(c("white",cccol[2]), bias=1)(100)
plotMatrix <- hm_promoter[c(K4me3UniqC4,commonC4,methyUniqC4),rev(n_K4me3_path)]
ColorLevels <- seq(to=K4me3_max,from=K4me3_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(hm_n_label),las=2)
abline(v=length(K4me3UniqC4)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC4)+length(commonC4)+0.5,lty=1,lwd=3)
# K27me3
ColorRamp <- colorRampPalette(c("white",cccol[3]), bias=1)(100)
plotMatrix <- hm_promoter[c(K4me3UniqC4,commonC4,methyUniqC4),rev(n_K27me3_path)]
ColorLevels <- seq(to=K27me3_max,from=K27me3_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(hm_n_label),las=2)
abline(v=length(K4me3UniqC4)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC4)+length(commonC4)+0.5,lty=1,lwd=3)
# CGratio
ColorRamp <- colorRampPalette(c(cccol[6],"white",cccol[5]), bias=1)(100)
plotMatrix <- as.matrix(cg_ratio[c(K4me3UniqC4,commonC4,methyUniqC4),1])
plotMatrix[plotMatrix<CG_ratio_min] <- CG_ratio_min
plotMatrix[plotMatrix>CG_ratio_max] <- CG_ratio_max
ColorLevels <- seq(to=CG_ratio_max,from=CG_ratio_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels="GCcontent",las=2)
abline(v=length(K4me3UniqC4)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC4)+length(commonC4)+0.5,lty=1,lwd=3)
# CG class
ColorRamp <- colorRampPalette(c(cccol[1],cccol[2],cccol[3]), bias=1)(100)
plotMatrix <- as.matrix(cg_ratio[c(K4me3UniqC11,commonC11,methyUniqC11),1])
CG_ratio_max <- 0.75
CG_ratio_min <- 0.5
plotMatrix[plotMatrix<=CG_ratio_min] <- 1
plotMatrix[plotMatrix<CG_ratio_max & plotMatrix>CG_ratio_min] <- 0.5
plotMatrix[plotMatrix>=CG_ratio_max] <- 0
ColorLevels <- seq(to=1,from=0, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels="GC class",las=2)
abline(v=length(K4me3UniqC4)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC4)+length(commonC11)+0.5,lty=1,lwd=3)
dev.off()

pdf("UP-LATE.pdf",width=length(C5)/20+1,height=6)
par(oma=c(0.5,0.5,0.5,0.5),mar=c(1,4,1,2))
layout(matrix(c(rep(1,6),rep(2,3),rep(3,2),rep(4,2),rep(5,2),rep(6,1),rep(7,1)),nrow=17,ncol=1,byrow=T))
# gene expression
ColorRamp <- colorRampPalette(c("white","lightblue","#FF3300","red"), bias=1)(1000)
plotMatrix <- nData[c(K4me3UniqC5,commonC5,methyUniqC5),rev(n_time_point)]
plotMatrix[plotMatrix<exp_min] <- exp_min
plotMatrix[plotMatrix>exp_max] <- exp_max
ColorLevels <- seq(to=exp_max,from=exp_min, length=1000)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), plotMatrix, axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(n_label),las=2)
abline(v=length(K4me3UniqC5)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC5)+length(commonC5)+0.5,lty=1,lwd=3)
# DNA methylation
ColorRamp <- colorRampPalette(c("white","black"), bias=1)(100)
plotMatrix <- methyratio_promoter[c(K4me3UniqC5,commonC5,methyUniqC5),rev(methy_n_path)]
# plotMatrix[is.na(plotMatrix)] <- 0
ColorLevels <- seq(to=methy_max,from=methy_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(methy_n_label),las=2)
abline(v=length(K4me3UniqC5)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC5)+length(commonC5)+0.5,lty=1,lwd=3)
# K4me2
ColorRamp <- colorRampPalette(c("white",cccol[1]), bias=1)(100)
plotMatrix <- hm_promoter[c(K4me3UniqC5,commonC5,methyUniqC5),rev(n_K4me2_path)]
ColorLevels <- seq(to=K4me2_max,from=K4me2_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(hm_n_label),las=2)
abline(v=length(K4me3UniqC5)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC5)+length(commonC5)+0.5,lty=1,lwd=3)
# K4me3
ColorRamp <- colorRampPalette(c("white",cccol[2]), bias=1)(100)
plotMatrix <- hm_promoter[c(K4me3UniqC5,commonC5,methyUniqC5),rev(n_K4me3_path)]
ColorLevels <- seq(to=K4me3_max,from=K4me3_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(hm_n_label),las=2)
abline(v=length(K4me3UniqC5)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC5)+length(commonC5)+0.5,lty=1,lwd=3)
# K27me3
ColorRamp <- colorRampPalette(c("white",cccol[3]), bias=1)(100)
plotMatrix <- hm_promoter[c(K4me3UniqC5,commonC5,methyUniqC5),rev(n_K27me3_path)]
ColorLevels <- seq(to=K27me3_max,from=K27me3_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(hm_n_label),las=2)
abline(v=length(K4me3UniqC5)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC5)+length(commonC5)+0.5,lty=1,lwd=3)
# CGratio
ColorRamp <- colorRampPalette(c(cccol[6],"white",cccol[5]), bias=1)(100)
plotMatrix <- as.matrix(cg_ratio[c(K4me3UniqC5,commonC5,methyUniqC5),1])
plotMatrix[plotMatrix<CG_ratio_min] <- CG_ratio_min
plotMatrix[plotMatrix>CG_ratio_max] <- CG_ratio_max
ColorLevels <- seq(to=CG_ratio_max,from=CG_ratio_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels="GCcontent",las=2)
abline(v=length(K4me3UniqC5)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC5)+length(commonC5)+0.5,lty=1,lwd=3)
# CG class
ColorRamp <- colorRampPalette(c(cccol[1],cccol[2],cccol[3]), bias=1)(100)
plotMatrix <- as.matrix(cg_ratio[c(K4me3UniqC11,commonC11,methyUniqC11),1])
CG_ratio_max <- 0.75
CG_ratio_min <- 0.5
plotMatrix[plotMatrix<CG_ratio_min] <- 0
plotMatrix[plotMatrix<CG_ratio_max & plotMatrix>CG_ratio_min] <- 0.5
plotMatrix[plotMatrix>CG_ratio_max] <- 1
ColorLevels <- seq(to=1,from=0, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels="GC class",las=2)
abline(v=length(K4me3UniqC5)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC5)+length(commonC11)+0.5,lty=1,lwd=3)
dev.off()

pdf("DOWN-LATE.pdf",width=length(C11)/20+1,height=6)
par(oma=c(0.5,0.5,0.5,0.5),mar=c(1,4,1,2))
layout(matrix(c(rep(1,6),rep(2,3),rep(3,2),rep(4,2),rep(5,2),rep(6,1),rep(7,1)),nrow=17,ncol=1,byrow=T))
# gene expression
ColorRamp <- colorRampPalette(c("white","lightblue","#FF3300","red"), bias=1)(1000)
plotMatrix <- nData[c(K4me3UniqC11,commonC11,methyUniqC11),rev(n_time_point)]
plotMatrix[plotMatrix<exp_min] <- exp_min
plotMatrix[plotMatrix>exp_max] <- exp_max
ColorLevels <- seq(to=exp_max,from=exp_min, length=1000)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), plotMatrix, axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(n_label),las=2)
abline(v=length(K4me3UniqC11)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC11)+length(commonC11)+0.5,lty=1,lwd=3)
# DNA methylation
ColorRamp <- colorRampPalette(c("white","black"), bias=1)(100)
plotMatrix <- methyratio_promoter[c(K4me3UniqC11,commonC11,methyUniqC11),rev(methy_n_path)]
# plotMatrix[is.na(plotMatrix)] <- 0
ColorLevels <- seq(to=methy_max,from=methy_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(methy_n_label),las=2)
abline(v=length(K4me3UniqC11)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC11)+length(commonC11)+0.5,lty=1,lwd=3)
# K4me2
ColorRamp <- colorRampPalette(c("white",cccol[1]), bias=1)(100)
plotMatrix <- hm_promoter[c(K4me3UniqC11,commonC11,methyUniqC11),rev(n_K4me2_path)]
ColorLevels <- seq(to=K4me2_max,from=K4me2_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(hm_n_label),las=2)
abline(v=length(K4me3UniqC11)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC11)+length(commonC11)+0.5,lty=1,lwd=3)
# K4me3
ColorRamp <- colorRampPalette(c("white",cccol[2]), bias=1)(100)
plotMatrix <- hm_promoter[c(K4me3UniqC11,commonC11,methyUniqC11),rev(n_K4me3_path)]
ColorLevels <- seq(to=K4me3_max,from=K4me3_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(hm_n_label),las=2)
abline(v=length(K4me3UniqC11)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC11)+length(commonC11)+0.5,lty=1,lwd=3)
# K27me3
ColorRamp <- colorRampPalette(c("white",cccol[3]), bias=1)(100)
plotMatrix <- hm_promoter[c(K4me3UniqC11,commonC11,methyUniqC11),rev(n_K27me3_path)]
ColorLevels <- seq(to=K27me3_max,from=K27me3_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=rev(hm_n_label),las=2)
abline(v=length(K4me3UniqC11)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC11)+length(commonC11)+0.5,lty=1,lwd=3)
# CGratio
ColorRamp <- colorRampPalette(c(cccol[6],"white",cccol[5]), bias=1)(100)
plotMatrix <- as.matrix(cg_ratio[c(K4me3UniqC11,commonC11,methyUniqC11),1])
plotMatrix[plotMatrix<CG_ratio_min] <- CG_ratio_min
plotMatrix[plotMatrix>CG_ratio_max] <- CG_ratio_max
ColorLevels <- seq(to=CG_ratio_max,from=CG_ratio_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
abline(v=length(K4me3UniqC11)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC11)+length(commonC11)+0.5,lty=1,lwd=3)
# CG class
ColorRamp <- colorRampPalette(c(cccol[1],cccol[2],cccol[3]), bias=1)(100)
plotMatrix <- as.matrix(cg_ratio[c(K4me3UniqC11,commonC11,methyUniqC11),1])
CG_ratio_max <- 0.75
CG_ratio_min <- 0.5
plotMatrix[plotMatrix<CG_ratio_min] <- 0
plotMatrix[plotMatrix<CG_ratio_max & plotMatrix>CG_ratio_min] <- 0.5
plotMatrix[plotMatrix>CG_ratio_max] <- 1
ColorLevels <- seq(to=1,from=0, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
abline(v=length(K4me3UniqC11)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC11)+length(commonC11)+0.5,lty=1,lwd=3)
dev.off()

pdf("DOWN-EARLY.pdf",width=length(C10)/20+1.2,height=6)
par(oma=c(0.5,0.5,0.5,0.5),mar=c(1,6,1,2))
layout(matrix(c(rep(1,6),rep(2,3),rep(3,2),rep(4,2),rep(5,2),rep(6,1),rep(7,1)),nrow=17,ncol=1,byrow=T))
# gene expression
ColorRamp <- colorRampPalette(c("white","lightblue","#FF3300","red"), bias=1)(1000)
plotMatrix <- nData[c(K4me3UniqC10,commonC10,methyUniqC10),rev(n_time_point)]
plotMatrix[plotMatrix<exp_min] <- exp_min
plotMatrix[plotMatrix>exp_max] <- exp_max
ColorLevels <- seq(to=exp_max,from=exp_min, length=1000)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), plotMatrix, axes=F, col=ColorRamp, xlab="",ylab="")
axis(side=2,1:ncol(plotMatrix),labels=rev(n_label),las=2)
abline(v=length(K4me3UniqC10)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC10)+length(commonC10)+0.5,lty=1,lwd=3)
# DNA methylation
ColorRamp <- colorRampPalette(c("white","black"), bias=1)(100)
plotMatrix <- methyratio_promoter[c(K4me3UniqC10,commonC10,methyUniqC10),rev(methy_n_path)]
# plotMatrix[is.na(plotMatrix)] <- 0
ColorLevels <- seq(to=methy_max,from=methy_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
axis(side=2,1:ncol(plotMatrix),labels=rev(methy_n_label),las=2)
abline(v=length(K4me3UniqC10)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC10)+length(commonC10)+0.5,lty=1,lwd=3)
# K4me2
ColorRamp <- colorRampPalette(c("white",cccol[1]), bias=1)(100)
plotMatrix <- hm_promoter[c(K4me3UniqC10,commonC10,methyUniqC10),rev(n_K4me2_path)]
ColorLevels <- seq(to=K4me2_max,from=K4me2_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
axis(side=2,1:ncol(plotMatrix),labels=rev(hm_n_label),las=2)
abline(v=length(K4me3UniqC10)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC10)+length(commonC10)+0.5,lty=1,lwd=3)
# K4me3
ColorRamp <- colorRampPalette(c("white",cccol[2]), bias=1)(100)
plotMatrix <- hm_promoter[c(K4me3UniqC10,commonC10,methyUniqC10),rev(n_K4me3_path)]
ColorLevels <- seq(to=K4me3_max,from=K4me3_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
axis(side=2,1:ncol(plotMatrix),labels=rev(hm_n_label),las=2)
abline(v=length(K4me3UniqC10)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC10)+length(commonC10)+0.5,lty=1,lwd=3)
# K27me3
ColorRamp <- colorRampPalette(c("white",cccol[3]), bias=1)(100)
plotMatrix <- hm_promoter[c(K4me3UniqC10,commonC10,methyUniqC10),rev(n_K27me3_path)]
ColorLevels <- seq(to=K27me3_max,from=K27me3_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
axis(side=2,1:ncol(plotMatrix),labels=rev(hm_n_label),las=2)
abline(v=length(K4me3UniqC10)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC10)+length(commonC10)+0.5,lty=1,lwd=3)
# CGratio
ColorRamp <- colorRampPalette(c(cccol[6],"white",cccol[5]), bias=1)(100)
plotMatrix <- as.matrix(cg_ratio[c(K4me3UniqC10,commonC10,methyUniqC10),1])
plotMatrix[plotMatrix<CG_ratio_min] <- CG_ratio_min
plotMatrix[plotMatrix>CG_ratio_max] <- CG_ratio_max
ColorLevels <- seq(to=CG_ratio_max,from=CG_ratio_min, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
axis(side=2,1:ncol(plotMatrix),labels="GCcontent",las=2)
abline(v=length(K4me3UniqC10)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC10)+length(commonC10)+0.5,lty=1,lwd=3)
# CG class
ColorRamp <- colorRampPalette(c(cccol[1],cccol[2],cccol[3]), bias=1)(100)
plotMatrix <- as.matrix(cg_ratio[c(K4me3UniqC10,commonC10,methyUniqC10),1])
CG_ratio_max <- 0.75
CG_ratio_min <- 0.5
plotMatrix[plotMatrix<CG_ratio_min] <- 0
plotMatrix[plotMatrix<CG_ratio_max & plotMatrix>CG_ratio_min] <- 0.5
plotMatrix[plotMatrix>CG_ratio_max] <- 1
ColorLevels <- seq(to=1,from=0, length=100)
image(1:nrow(plotMatrix), 1:ncol(plotMatrix), as.matrix(plotMatrix), axes=F, col=ColorRamp, xlab="",ylab="")
axis(side=2,1:ncol(plotMatrix),labels="GC class",las=2)
abline(v=length(K4me3UniqC10)+0.5,lty=1,lwd=3)
abline(v=length(K4me3UniqC10)+length(commonC10)+0.5,lty=1,lwd=3)
dev.off()


pdf("legend.pdf",width=1,height=6)
par(oma=c(0.5,0.5,0.5,0.5),mar=c(1,3,1,3))
layout(matrix(c(rep(1,6),rep(2,3),rep(3,2),rep(4,2),rep(5,2),rep(6,1),rep(7,1)),nrow=17,ncol=1,byrow=T))
ColorRamp <- colorRampPalette(c("white","lightblue","#FF3300","red"), bias=1)(1000)
ColorLevels <- seq(to=exp_max,from=exp_min, length=1000)
image(1,ColorLevels,t(matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1)),col=t(ColorRamp), xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
axis(side=4,c(exp_min,round((exp_max-exp_min)/2,1),exp_max),labels=c(round(exp_min,2),round((exp_max-exp_min)/2,1),round(exp_max,1)),las=2)
ColorRamp <- colorRampPalette(c("white","black"), bias=1)(100)
ColorLevels <- seq(to=methy_max,from=methy_min, length=100)
image(1,ColorLevels,t(matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1)),col=t(ColorRamp), xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
axis(side=4,c(methy_min,round((methy_max-methy_min)/2,1),methy_max),labels=c(round(methy_min,2),round((methy_max-methy_min)/2,1),round(methy_max,1)),las=2)
ColorRamp <- colorRampPalette(c("white",cccol[1]), bias=1)(100)
ColorLevels <- seq(to=K4me2_max,from=K4me2_min, length=100)
image(1,ColorLevels,t(matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1)),col=t(ColorRamp), xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
axis(side=4,c(K4me2_min,round((K4me2_max-K4me2_min)/2,1),K4me2_max),labels=c(round(K4me2_min,2),round((K4me2_max-K4me2_min)/2,1),round(K4me2_max,1)),las=2)
ColorRamp <- colorRampPalette(c("white",cccol[2]), bias=1)(100)
ColorLevels <- seq(to=K4me3_max,from=K4me3_min, length=100)
image(1,ColorLevels,t(matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1)),col=t(ColorRamp), xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
axis(side=4,c(K4me3_min,round((K4me3_max-K4me3_min)/2,1),K4me3_max),labels=c(round(K4me3_min,2),round((K4me3_max-K4me3_min)/2,1),round(K4me3_max,1)),las=2)
ColorRamp <- colorRampPalette(c("white",cccol[3]), bias=1)(100)
ColorLevels <- seq(to=K27me3_max,from=K27me3_min, length=100)
image(1,ColorLevels,t(matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1)),col=t(ColorRamp), xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
axis(side=4,c(K27me3_min,round((K27me3_max-K27me3_min)/2,1),K27me3_max),labels=c(round(K27me3_min,2),round((K27me3_max-K27me3_min)/2,1),round(K27me3_max,1)),las=2)
ColorRamp <- colorRampPalette(c(cccol[6],"white",cccol[5]), bias=1)(100)
ColorLevels <- seq(to=CG_ratio_max,from=CG_ratio_min, length=100)
image(1,ColorLevels,t(matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1)),col=t(ColorRamp), xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
axis(side=4,c(CG_ratio_min,CG_ratio_max),labels=c(round(CG_ratio_min,1),round(CG_ratio_max,1)),las=2)
ColorLevels <- c(0,0.5,1)
ColorRamp <- c(cccol[1],cccol[2],cccol[3])
image(1,ColorLevels,t(matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1)),col=t(ColorRamp), xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n")
axis(side=4,ColorLevels,labels=c("LCP","ICP","HCP"),las=2,cex.axis=0.5)
dev.off()